/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.tracker;

import filenet.vw.apps.tracker.VWTrackerCore;
import filenet.vw.apps.tracker.images.VWImageLoader;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Dimension;
import javax.swing.ImageIcon;

public class VWTrackerApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWTrackerCore m_trackerCore = null;
    private VWSplashWindow m_splashWindow = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(null)) {
                System.exit(1);
            }
            VWTrackerApplication pApp = new VWTrackerApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            ImageIcon icon = VWImageLoader.createImageIcon("tracker.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            this.setFormattedWindowTitle(VWIDMBaseFactory.instance().getVWString(6).toString());
            this.m_splashWindow = new VWSplashWindow(this);
            if (!this.updatePosition("tracker_location", "tracker_size")) {
                Dimension dim = VWStringUtils.stringToDimension("800,600");
                if (dim == null) {
                    dim = new Dimension(800, 600);
                }
                this.updatePosition(dim.width, dim.height);
            }
            this.show();
            if (this.m_splashWindow != null) {
                this.m_splashWindow.start(this, 250);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        if (this.m_trackerCore != null) {
            return;
        }
        try {
            this.m_trackerCore = new VWTrackerCore();
            this.m_trackerCore.setSplashWindow(this.m_splashWindow);
            this.m_trackerCore.init(this.m_sessionInfo);
            this.m_trackerCore.setSplashWindow(null);
            this.m_splashWindow = null;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void childWindowClosed() {
        if (this.m_trackerCore != null) {
            this.m_trackerCore.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean destroy() {
        try {
            if (this.m_trackerCore != null) {
                this.m_trackerCore.doExit();
            }
            boolean bl = super.destroy();
            return bl;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_trackerCore = null;
            System.runFinalization();
            System.gc();
        }
        return false;
    }
}

